/*
 * Decompiled with CFR 0.152.
 */
package filius.gui.anwendungssicht;

import filius.gui.JExtendedTable;
import filius.gui.anwendungssicht.GUIApplicationDNSServerWindow;
import filius.rahmenprogramm.EingabenUeberpruefung;
import filius.software.dns.DNSServer;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class DNSConfigTable
extends JExtendedTable {
    private String typeID = null;

    public DNSConfigTable(TableModel model, boolean editable, String type) {
        super(model, editable);
        this.typeID = type;
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            String value = (String)editor.getCellEditorValue();
            value = value.trim();
            DNSServer dnsServer = (DNSServer)((GUIApplicationDNSServerWindow)this.parentGUI).holeAnwendung();
            if (this.typeID != null && this.typeID.equals("A")) {
                if (this.editingColumn == 0) {
                    boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                    if (validChange) {
                        dnsServer.changeSingleEntry(this.editingRow, 0, "A", value);
                    }
                } else {
                    boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterIpAdresse);
                    if (validChange) {
                        dnsServer.changeSingleEntry(this.editingRow, 3, "A", value);
                    }
                }
            } else if (this.typeID != null && this.typeID.equals("MX")) {
                if (this.editingColumn == 0) {
                    boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                    if (validChange) {
                        dnsServer.changeSingleEntry(this.editingRow, 0, "MX", value);
                    }
                } else {
                    boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                    if (validChange) {
                        dnsServer.changeSingleEntry(this.editingRow, 3, "MX", value);
                    }
                }
            } else if (this.typeID != null && this.typeID.equals("NS")) {
                if (this.editingColumn == 0) {
                    boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                    if (validChange) {
                        dnsServer.changeSingleEntry(this.editingRow, 0, "NS", value);
                    }
                } else {
                    boolean validChange = EingabenUeberpruefung.isGueltig(value, EingabenUeberpruefung.musterDomain);
                    if (validChange) {
                        dnsServer.changeSingleEntry(this.editingRow, 3, "NS", value);
                    }
                }
            }
            this.removeEditor();
        }
    }

    public String getType() {
        return this.typeID;
    }
}

