/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.gui.JMainFrame;
import filius.gui.anwendungssicht.SatViewer;
import filius.hardware.knoten.Switch;
import filius.rahmenprogramm.I18n;
import filius.software.system.SystemSoftware;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SatViewerControl
implements I18n {
    private Map<SystemSoftware, SatViewer> satViewer = new HashMap<SystemSoftware, SatViewer>();
    private Set<SystemSoftware> visibleViewer = new HashSet<SystemSoftware>();
    private static SatViewerControl singleton;

    private SatViewerControl() {
    }

    public static SatViewerControl getInstance() {
        if (null == singleton) {
            singleton = new SatViewerControl();
        }
        return singleton;
    }

    public void hideViewer() {
        this.visibleViewer.clear();
        for (SatViewer viewer : this.satViewer.values()) {
            if (viewer.isVisible()) {
                this.visibleViewer.add(viewer.getSwitch().getSystemSoftware());
            }
            viewer.setVisible(false);
        }
    }

    public void showViewer(Switch sw) {
        if (!this.satViewer.containsKey(sw.getSystemSoftware())) {
            SatViewer viewer = new SatViewer(sw);
            viewer.setLocation(JMainFrame.getJMainFrame().getX() + (JMainFrame.getJMainFrame().getWidth() - viewer.getWidth()) / 2, JMainFrame.getJMainFrame().getY() + (JMainFrame.getJMainFrame().getHeight() - viewer.getHeight()) / 2);
            sw.getSystemSoftware().addPropertyChangeListener(viewer);
            this.satViewer.put(sw.getSystemSoftware(), viewer);
        }
        this.satViewer.get(sw.getSystemSoftware()).setVisible(true);
    }

    public void removeViewer(SystemSoftware systemSoftware) {
        this.satViewer.remove(systemSoftware);
    }

    public void reshowViewer(Set<SystemSoftware> activeSystemSoftware) {
        HashSet<SystemSoftware> satToRemove = new HashSet<SystemSoftware>();
        for (SystemSoftware sysSoftawre : this.satViewer.keySet()) {
            if (!activeSystemSoftware.contains(sysSoftawre)) {
                satToRemove.add(sysSoftawre);
                continue;
            }
            if (!this.visibleViewer.contains(sysSoftawre)) continue;
            this.satViewer.get(sysSoftawre).setVisible(true);
        }
        for (SystemSoftware sysSoftware : satToRemove) {
            this.satViewer.remove(sysSoftware);
        }
    }
}

