/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.gui.ControlPanel;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.ResourceUtil;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import javax.swing.JEditorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpPanel
extends ControlPanel
implements I18n {
    private static Logger LOG = LoggerFactory.getLogger(HelpPanel.class);
    private JEditorPane epHtml;

    public HelpPanel() {
        super(0, 350);
        this.reInit();
        this.minimieren();
    }

    @Override
    protected void initContents() {
        this.epHtml = new JEditorPane("text/html;charset=UTF-8", null);
        this.epHtml.setText(messages.getString("guihilfe_msg2"));
        this.epHtml.setEditable(false);
        this.epHtml.setMinimumSize(new Dimension(1, 1));
        this.scrollPane.getViewport().removeAll();
        this.scrollPane.getViewport().add(this.epHtml);
    }

    public void loadContext(int mode) {
        File file;
        switch (mode) {
            case 2: {
                file = ResourceUtil.getResourceFile("hilfe/" + messages.getString("hilfedatei_simulation"));
                break;
            }
            case 1: {
                file = ResourceUtil.getResourceFile("hilfe/" + messages.getString("hilfedatei_entwurf"));
                break;
            }
            default: {
                file = ResourceUtil.getResourceFile("hilfe/" + messages.getString("hilfedatei_documentation"));
            }
        }
        LOG.debug("Help file: " + file.getAbsolutePath());
        String gfxBaseUrl = "file:" + ResourceUtil.getResourceUrlEncodedPath("hilfe/gfx/");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));){
            StringBuffer sb = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                sb.append(line);
                line = reader.readLine();
            }
            String newText = sb.toString();
            String escapedGfxBaseUrl = Matcher.quoteReplacement(gfxBaseUrl);
            newText = newText.replaceAll("hilfe/gfx/", escapedGfxBaseUrl);
            this.epHtml.read(new StringReader(newText), null);
            this.epHtml.setCaretPosition(0);
        }
        catch (FileNotFoundException e) {
            LOG.warn("help contents could not be found", e);
        }
        catch (IOException e) {
            LOG.warn("error while reading help contents", e);
        }
    }
}

