/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.gui.ControlPanel;
import filius.gui.GUIEvents;
import filius.gui.GUIMainMenu;
import filius.gui.HelpPanel;
import filius.gui.JBackgroundPanel;
import filius.gui.JMainFrame;
import filius.gui.JMarkerPanel;
import filius.gui.SatViewerControl;
import filius.gui.anwendungssicht.GUIDesktopWindow;
import filius.gui.anwendungssicht.SimulationControl;
import filius.gui.nachrichtensicht.AggregatedExchangeDialog;
import filius.gui.nachrichtensicht.ExchangeComponent;
import filius.gui.nachrichtensicht.LayeredExchangeDialog;
import filius.gui.netzwerksicht.GUIDesignSidebar;
import filius.gui.netzwerksicht.GUIDocuItem;
import filius.gui.netzwerksicht.GUIDocumentationPanel;
import filius.gui.netzwerksicht.GUIDocumentationSidebar;
import filius.gui.netzwerksicht.GUIKabelItem;
import filius.gui.netzwerksicht.GUIKnotenItem;
import filius.gui.netzwerksicht.GUINetworkPanel;
import filius.gui.netzwerksicht.GUIPrintPanel;
import filius.gui.netzwerksicht.JCablePanel;
import filius.gui.netzwerksicht.JDocuElement;
import filius.gui.netzwerksicht.JKonfiguration;
import filius.gui.netzwerksicht.JSidebarButton;
import filius.hardware.Hardware;
import filius.hardware.Kabel;
import filius.hardware.NetzwerkInterface;
import filius.hardware.knoten.Gateway;
import filius.hardware.knoten.Host;
import filius.hardware.knoten.InternetKnoten;
import filius.hardware.knoten.Knoten;
import filius.hardware.knoten.Modem;
import filius.hardware.knoten.Notebook;
import filius.hardware.knoten.Rechner;
import filius.hardware.knoten.Switch;
import filius.hardware.knoten.Vermittlungsrechner;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import filius.rahmenprogramm.nachrichten.Lauscher;
import filius.software.system.Betriebssystem;
import filius.software.system.SystemSoftware;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class GUIContainer
implements Serializable,
I18n {
    private static Logger LOG = LoggerFactory.getLogger(GUIContainer.class);
    private static final int MIN_DESKTOP_SPACING = 10;
    private static final Integer ACTIVE_LISTENER_LAYER = 1;
    private static final Integer INACTIVE_LISTENER_LAYER = -2;
    private static final Integer BACKGROUND_LAYER = -10;
    public static final int NONE = 0;
    public static final int MOVE = 1;
    public static final int LEFT_SIZING = 2;
    public static final int RIGHT_SIZING = 4;
    public static final int UPPER_SIZING = 8;
    public static final int LOWER_SIZING = 16;
    private static final long serialVersionUID = 1L;
    public static final int FLAECHE_BREITE = 2000;
    public static final int FLAECHE_HOEHE = 1500;
    private static GUIContainer ref;
    private GUIMainMenu menu;
    private int width = 2000;
    private int height = 1500;
    private GUINetworkPanel networkPanel;
    private JPanel designListenerPanel = new JPanel();
    private JLayeredPane layeredPane = new JLayeredPane();
    private GUIDocumentationSidebar docuSidebar;
    private GUIDocumentationPanel docuPanel;
    private JScrollPane docuSidebarScrollpane;
    private JPanel docuDragPanel = new JPanel();
    private JDocuElement activeDocuElement;
    private GUIDesignSidebar designSidebar;
    private JBackgroundPanel designBackgroundPanel = new JBackgroundPanel();
    private ControlPanel designItemConfig = JKonfiguration.getInstance(null);
    private HelpPanel helpPanel = new HelpPanel();
    private JScrollPane designView;
    private JScrollPane designSidebarScrollpane;
    private JSidebarButton designDragPreview;
    private JSidebarButton designCablePreview;
    private JSidebarButton ziel2Label;
    private JCablePanel kabelPanelVorschau;
    private JMarkerPanel designSelection;
    private JMarkerPanel designSelectionArea;
    private JBackgroundPanel simulationBackgroundPanel = new JBackgroundPanel();
    private JScrollPane simulationView;
    private List<GUIDesktopWindow> desktopWindowList = new LinkedList<GUIDesktopWindow>();
    private boolean lastVisibilityStateLauscher;
    private int activeSite = 1;
    private List<GUIKnotenItem> nodeItems = new LinkedList<GUIKnotenItem>();
    private List<GUIKabelItem> cableItems = new LinkedList<GUIKabelItem>();
    private List<GUIDocuItem> docuItems = new ArrayList<GUIDocuItem>();
    private Set<SystemSoftware> visibleSystems = new HashSet<SystemSoftware>();
    private Hardware lastOpenDesignComponent;
    private boolean lastSimulationControlMaximized;

    private GUIContainer(int width, int height) {
        this.width = width;
        this.height = height;
        this.docuPanel = new GUIDocumentationPanel(width, height);
        this.docuPanel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GUIContainer.this.activeSite == 3) {
                    GUIEvents.getGUIEvents().mausPressedDocuMode(e);
                }
            }
        });
        this.networkPanel = new GUINetworkPanel(width, height);
        this.networkPanel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (GUIContainer.this.activeSite == 2) {
                    GUIEvents.getGUIEvents().mausPressedActionMode(e);
                }
            }
        });
    }

    public List<GUIKnotenItem> getKnotenItems() {
        return this.nodeItems;
    }

    public void removeNodeItem(GUIKnotenItem item) {
        this.nodeItems.remove(item);
        Knoten node = item.getKnoten();
        if (node instanceof InternetKnoten) {
            for (NetzwerkInterface nic : ((InternetKnoten)node).getNetzwerkInterfaces()) {
                Lauscher.getLauscher().removeIdentifier(nic.getMac());
            }
        }
    }

    public JSidebarButton getZiel2Label() {
        return this.ziel2Label;
    }

    public void setZiel2Label(JSidebarButton ziel2Label) {
        this.ziel2Label = ziel2Label;
    }

    public void nachrichtenDialogAnzeigen() {
        ((JDialog)((Object)this.getExchangeDialog())).setVisible(true);
    }

    public ExchangeComponent getExchangeDialog() {
        JDialog exchangeDialog = Information.getInformation().isOldExchangeDialog() ? LayeredExchangeDialog.getInstance(JMainFrame.getJMainFrame()) : AggregatedExchangeDialog.getInstance(JMainFrame.getJMainFrame());
        return exchangeDialog;
    }

    private void initialisieren() {
        this.layeredPane.setSize(this.width, this.height);
        this.layeredPane.setMinimumSize(new Dimension(this.width, this.height));
        this.layeredPane.setPreferredSize(new Dimension(this.width, this.height));
        this.designListenerPanel.setSize(this.width, this.height);
        this.designListenerPanel.setMinimumSize(new Dimension(this.width, this.height));
        this.designListenerPanel.setPreferredSize(new Dimension(this.width, this.height));
        this.designListenerPanel.setOpaque(false);
        this.layeredPane.add((Component)this.designListenerPanel, ACTIVE_LISTENER_LAYER);
        this.designSelection = new JMarkerPanel();
        this.designSelection.setBounds(0, 0, 0, 0);
        this.designSelection.setBackgroundImage("gfx/allgemein/auswahl.png");
        this.designSelection.setOpaque(false);
        this.designSelection.setVisible(true);
        this.layeredPane.add((Component)this.designSelection, JLayeredPane.DRAG_LAYER);
        this.designCablePreview = new JSidebarButton("", (Icon)new ImageIcon(this.getClass().getResource("/gfx/allgemein/ziel1.png")), null);
        this.designCablePreview.setVisible(false);
        this.layeredPane.add((Component)this.designCablePreview, JLayeredPane.DRAG_LAYER);
        this.designDragPreview = new JSidebarButton();
        this.designDragPreview.setVisible(false);
        this.layeredPane.add((Component)this.designDragPreview, JLayeredPane.DRAG_LAYER);
        this.menu = new GUIMainMenu();
        JMainFrame.getJMainFrame().addToContentPane(this.menu.getMenupanel(), "North");
        JMainFrame.getJMainFrame().addToContentPane(this.helpPanel, "East");
        this.setProperty(null);
        this.designSidebar = GUIDesignSidebar.getGUIDesignSidebar();
        this.docuSidebar = GUIDocumentationSidebar.getGUIDocumentationSidebar();
        this.designSelectionArea = new JMarkerPanel();
        this.designSelectionArea.setBounds(0, 0, 0, 0);
        this.designSelectionArea.setBackgroundImage("gfx/allgemein/markierung.png");
        this.designSelectionArea.setOpaque(false);
        this.designSelectionArea.setVisible(false);
        this.designSelectionArea.setCursor(new Cursor(13));
        this.layeredPane.add((Component)this.designSelectionArea, JLayeredPane.DRAG_LAYER);
        this.designSidebarScrollpane = new JScrollPane(this.designSidebar.getLeistenpanel());
        this.designSidebarScrollpane.setHorizontalScrollBarPolicy(31);
        if (Information.isLowResolution()) {
            this.designSidebarScrollpane.setVerticalScrollBarPolicy(22);
            this.designSidebarScrollpane.getVerticalScrollBar().setUnitIncrement(10);
        } else {
            this.designSidebarScrollpane.setVerticalScrollBarPolicy(21);
        }
        this.docuSidebarScrollpane = new JScrollPane(this.docuSidebar.getLeistenpanel());
        this.docuSidebarScrollpane.setVerticalScrollBarPolicy(21);
        this.layeredPane.add((Component)this.networkPanel, JLayeredPane.DEFAULT_LAYER);
        this.designBackgroundPanel.setBackgroundImage("gfx/allgemein/entwurfshg.png");
        this.designBackgroundPanel.setBounds(0, 0, this.width, this.height);
        this.docuDragPanel.setBounds(0, 0, this.width, this.height);
        this.docuDragPanel.setOpaque(false);
        this.layeredPane.add((Component)this.docuDragPanel, JLayeredPane.DRAG_LAYER);
        this.layeredPane.add((Component)this.docuPanel, INACTIVE_LISTENER_LAYER);
        this.designView = new JScrollPane(this.layeredPane);
        this.designView.getVerticalScrollBar().setUnitIncrement(10);
        this.simulationBackgroundPanel.setBackgroundImage("gfx/allgemein/simulationshg.png");
        this.simulationBackgroundPanel.setBounds(0, 0, this.width, this.height);
        this.simulationView = new JScrollPane();
        this.simulationView.getVerticalScrollBar().setUnitIncrement(10);
        this.designSidebarScrollpane.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JSidebarButton button = GUIContainer.this.designSidebar.findButtonAt(e.getX(), e.getY() + GUIContainer.this.designSidebarScrollpane.getVerticalScrollBar().getValue());
                if (button != null) {
                    GUIContainer.this.neueVorschau(button.getTyp(), e.getX() + GUIContainer.getGUIContainer().getXOffset() - GUIContainer.this.designSidebarScrollpane.getWidth(), e.getY() + GUIContainer.getGUIContainer().getYOffset());
                    GUIContainer.this.designDragPreview.setLocation(GUIContainer.this.designDragPreview.getX() - GUIContainer.this.designDragPreview.getWidth() / 2, GUIContainer.this.designDragPreview.getY() - GUIContainer.this.designDragPreview.getHeight() / 2);
                    GUIEvents.getGUIEvents().resetAndHideCablePreview();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GUIContainer.this.designDragPreview.isVisible() && e.getX() >= GUIContainer.this.designSidebarScrollpane.getWidth() && e.getX() <= GUIContainer.this.designView.getWidth() && e.getY() >= 0 && e.getY() <= GUIContainer.this.designView.getHeight()) {
                    int xPosMainArea = e.getX() - GUIContainer.this.designDragPreview.getWidth() / 2 - GUIContainer.this.designSidebarScrollpane.getWidth();
                    int yPosMainArea = e.getY() - GUIContainer.this.designDragPreview.getHeight() / 2;
                    GUIContainer.this.neuerKnoten(xPosMainArea, yPosMainArea, GUIContainer.this.designDragPreview);
                }
                GUIContainer.this.designDragPreview.setVisible(false);
            }
        });
        this.designSidebarScrollpane.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (GUIContainer.this.designDragPreview.isVisible()) {
                    GUIContainer.this.designDragPreview.setLocation(e.getX() + GUIContainer.getGUIContainer().getXOffset() - GUIContainer.this.designDragPreview.getWidth() / 2 - GUIContainer.this.designSidebarScrollpane.getWidth(), e.getY() + GUIContainer.getGUIContainer().getYOffset() - GUIContainer.this.designDragPreview.getHeight() / 2);
                }
            }
        });
        this.docuSidebarScrollpane.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JSidebarButton button = GUIContainer.this.docuSidebar.findButtonAt(e.getX(), e.getY());
                if (button != null) {
                    if ("rectangle".equals(button.getTyp())) {
                        GUIContainer.this.activeDocuElement = new JDocuElement(false, true);
                    } else if ("textfield".equals(button.getTyp())) {
                        GUIContainer.this.activeDocuElement = new JDocuElement(true, true);
                    }
                    GUIContainer.this.activeDocuElement.setSelected(true);
                    GUIContainer.this.activeDocuElement.setLocation(e.getX() - GUIContainer.this.designSidebarScrollpane.getWidth() + GUIContainer.getGUIContainer().getXOffset(), e.getY() + GUIContainer.getGUIContainer().getYOffset());
                    GUIContainer.this.docuDragPanel.add(GUIContainer.this.activeDocuElement);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getX() > GUIContainer.this.docuSidebarScrollpane.getWidth() && GUIContainer.this.activeDocuElement != null) {
                    GUIContainer.this.docuItems.add(GUIDocuItem.createDocuItem(GUIContainer.this.activeDocuElement));
                    SzenarioVerwaltung.getInstance().setzeGeaendert();
                    GUIContainer.this.activeDocuElement.setSelected(false);
                    GUIContainer.this.docuDragPanel.remove(GUIContainer.this.activeDocuElement);
                    GUIContainer.this.docuPanel.add(GUIContainer.this.activeDocuElement);
                    GUIContainer.this.activeDocuElement.requestFocusInWindow();
                    GUIContainer.this.updateViewport();
                } else if (GUIContainer.this.activeDocuElement != null) {
                    GUIContainer.this.docuDragPanel.remove(GUIContainer.this.activeDocuElement);
                    GUIContainer.this.docuDragPanel.updateUI();
                }
                GUIContainer.this.activeDocuElement = null;
            }
        });
        this.docuSidebarScrollpane.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (GUIContainer.this.activeDocuElement != null) {
                    GUIContainer.this.activeDocuElement.setLocation(e.getX() + GUIContainer.getGUIContainer().getXOffset() - GUIContainer.this.activeDocuElement.getWidth() / 2 - GUIContainer.this.designSidebarScrollpane.getWidth(), e.getY() + GUIContainer.getGUIContainer().getYOffset() - GUIContainer.this.activeDocuElement.getHeight() / 2);
                }
            }
        });
        this.designListenerPanel.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (GUIContainer.this.activeSite == 1) {
                    GUIEvents.getGUIEvents().mausDragged(e);
                }
            }
        });
        this.designListenerPanel.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (GUIContainer.this.activeSite == 1) {
                    GUIEvents.getGUIEvents().mausReleased();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (GUIContainer.this.activeSite == 1) {
                    GUIEvents.getGUIEvents().mausPressedDesignMode(e);
                }
            }
        });
        this.designListenerPanel.addMouseMotionListener(new MouseInputAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (GUIContainer.this.designCablePreview.isVisible()) {
                    GUIContainer.this.designCablePreview.setBounds(e.getX(), e.getY(), GUIContainer.this.designCablePreview.getWidth(), GUIContainer.this.designCablePreview.getHeight());
                    if (GUIContainer.this.ziel2Label != null) {
                        GUIContainer.this.ziel2Label.setLocation(e.getX(), e.getY());
                    }
                    if (GUIContainer.this.kabelPanelVorschau != null) {
                        GUIContainer.this.kabelPanelVorschau.updateBounds();
                    }
                    LOG.trace(e.getX() + " / " + e.getY());
                    GUIEvents.getGUIEvents().updateGatewayPort(e.getX(), e.getY());
                }
            }
        });
        JMainFrame.getJMainFrame().setVisible(true);
        this.menu.selectMode(1);
    }

    public void exportAsImage() {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter pngFileFilter = new FileNameExtensionFilter("Portable Network Graphics", "png");
        FileNameExtensionFilter svgFileFilter = new FileNameExtensionFilter("Scalable Vector Graphics", "svg");
        fileChooser.addChoosableFileFilter(pngFileFilter);
        fileChooser.addChoosableFileFilter(svgFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        String path = SzenarioVerwaltung.getInstance().holePfad();
        if (path != null) {
            String szenarioFile = new File(path).getAbsolutePath();
            File preselectedFile = new File(szenarioFile.substring(0, szenarioFile.lastIndexOf(".")));
            fileChooser.setSelectedFile(preselectedFile);
        }
        if (fileChooser.showSaveDialog(JMainFrame.getJMainFrame()) == 0) {
            FileFilter selectedFileFilter = fileChooser.getFileFilter();
            FileType type = svgFileFilter.equals(selectedFileFilter) ? FileType.SVG : FileType.PNG;
            String imagePath = fileChooser.getSelectedFile().getAbsolutePath();
            imagePath = FileType.SVG == type ? (imagePath.endsWith(".svg") ? imagePath : imagePath + ".svg") : (imagePath.endsWith(".png") ? imagePath : imagePath + ".png");
            int entscheidung = 0;
            if (imagePath != null && new File(imagePath).exists()) {
                entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg17"), messages.getString("guimainmemu_msg10"), 0);
            }
            if (entscheidung == 0) {
                try {
                    if (FileType.SVG == type) {
                        this.exportAsSVG(imagePath);
                    } else {
                        this.exportAsPNG(imagePath);
                    }
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(JMainFrame.getJMainFrame(), messages.getString("guimainmemu_msg11"));
                }
            }
            LOG.debug("export to file: " + imagePath);
            this.updateViewport();
        }
    }

    private void exportAsPNG(String imagePath) throws IOException {
        BufferedImage printArea = this.createNetworkImage();
        try (FileImageOutputStream outputStream = new FileImageOutputStream(new File(imagePath));){
            ImageIO.write((RenderedImage)printArea, "png", outputStream);
        }
    }

    public BufferedImage createNetworkImage() {
        GUIPrintPanel printPanel = this.prepareExportPanel();
        BufferedImage bi = new BufferedImage(printPanel.getWidth(), printPanel.getHeight(), 2);
        Graphics2D g = bi.createGraphics();
        printPanel.paint(g);
        g.dispose();
        BufferedImage printArea = bi.getSubimage(printPanel.getClipX(), printPanel.getClipY(), printPanel.getClipWidth(), printPanel.getClipHeight());
        return printArea;
    }

    private void exportAsSVG(String imagePath) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault(document);
        ctx.setComment("Generated by Filius");
        ctx.setEmbeddedFontsOn(true);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(ctx, false);
        GUIPrintPanel printPanel = this.prepareExportPanel();
        printPanel.paint(svgGenerator);
        svgGenerator.dispose();
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(imagePath)), "UTF-8");){
            svgGenerator.stream(out, true);
        }
    }

    private GUIPrintPanel prepareExportPanel() {
        GUIPrintPanel printPanel = new GUIPrintPanel(this.width, this.height, SzenarioVerwaltung.getInstance().holePfad());
        printPanel.updateViewport(this.nodeItems, this.cableItems, this.docuItems);
        return printPanel;
    }

    private boolean neuerKnoten(int x, int y, JSidebarButton label) {
        GUIKnotenItem item;
        Knoten neuerKnoten = null;
        ImageIcon tempIcon = null;
        SzenarioVerwaltung.getInstance().setzeGeaendert();
        ListIterator<GUIKnotenItem> it = this.nodeItems.listIterator();
        while (it.hasNext()) {
            item = it.next();
            item.getImageLabel().setSelektiert(false);
        }
        GUIEvents.getGUIEvents().cancelMultipleSelection();
        if (label.getTyp().equals(Switch.TYPE)) {
            neuerKnoten = new Switch();
            tempIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/switch.png"));
        } else if (label.getTyp().equals(Rechner.TYPE)) {
            neuerKnoten = new Rechner();
            tempIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/server.png"));
        } else if (label.getTyp().equals(Notebook.TYPE)) {
            neuerKnoten = new Notebook();
            tempIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/laptop.png"));
        } else if (label.getTyp().equals(Vermittlungsrechner.TYPE)) {
            neuerKnoten = new Vermittlungsrechner();
            tempIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/router.png"));
            Object[] possibleValues = new Object[]{"2", "3", "4", "5", "6", "7", "8"};
            Object selectedValue = JOptionPane.showInputDialog(JMainFrame.getJMainFrame(), messages.getString("guicontainer_msg1"), messages.getString("guicontainer_msg2"), 1, null, possibleValues, possibleValues[0]);
            if (selectedValue != null) {
                ((Vermittlungsrechner)neuerKnoten).setzeAnzahlAnschluesse(Integer.parseInt((String)selectedValue));
            } else {
                ((Vermittlungsrechner)neuerKnoten).setzeAnzahlAnschluesse(2);
            }
        } else if (label.getTyp().equals("Modem")) {
            neuerKnoten = new Modem();
            tempIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/vermittlungsrechner-out.png"));
        } else if (label.getTyp().equals(Gateway.TYPE)) {
            neuerKnoten = new Gateway();
            tempIcon = new ImageIcon(this.getClass().getResource("/gfx/hardware/gateway.png"));
        } else {
            LOG.debug("ERROR (" + this.hashCode() + "): unbekannter Hardwaretyp " + label.getTyp() + " konnte nicht erzeugt werden.");
        }
        if (tempIcon != null && neuerKnoten != null) {
            JSidebarButton templabel = new JSidebarButton((Icon)tempIcon, neuerKnoten.holeHardwareTyp());
            templabel.setBounds((x >= 0 ? x : 0) + this.designView.getHorizontalScrollBar().getValue(), (y >= 0 ? y : 0) + this.designView.getVerticalScrollBar().getValue(), templabel.getWidth(), templabel.getHeight());
            templabel.initTextAndUpdateLocation(neuerKnoten.holeAnzeigeName());
            item = new GUIKnotenItem();
            item.setKnoten(neuerKnoten);
            item.setImageLabel(templabel);
            this.setProperty(neuerKnoten);
            item.getImageLabel().setSelektiert(true);
            this.nodeItems.add(item);
            this.networkPanel.add(templabel);
            this.networkPanel.repaint();
            GUIEvents.getGUIEvents().setNewItemActive(item);
            return true;
        }
        return false;
    }

    public static GUIContainer getGUIContainer() {
        return GUIContainer.getGUIContainer(2000, 1500);
    }

    public static GUIContainer getGUIContainer(int width, int height) {
        if (ref == null) {
            ref = new GUIContainer(width, height);
            if (ref == null) {
                LOG.debug("ERROR (static) getGUIContainer(): Fehler!!! ref==null");
            }
            ref.initialisieren();
        }
        return ref;
    }

    private void neueVorschau(String hardwareTyp, int x, int y) {
        String tmp;
        LOG.debug("GUIContainer: die Komponenten-Vorschau wird erstellt.");
        if (hardwareTyp.equals(Kabel.TYPE)) {
            tmp = "gfx/hardware/kabel.png";
        } else if (hardwareTyp.equals(Switch.TYPE)) {
            tmp = "gfx/hardware/switch.png";
        } else if (hardwareTyp.equals(Rechner.TYPE)) {
            tmp = "gfx/hardware/server.png";
        } else if (hardwareTyp.equals(Notebook.TYPE)) {
            tmp = "gfx/hardware/laptop.png";
        } else if (hardwareTyp.equals(Vermittlungsrechner.TYPE)) {
            tmp = "gfx/hardware/router.png";
        } else if (hardwareTyp.equals("Modem")) {
            tmp = "gfx/hardware/vermittlungsrechner-out.png";
        } else if (hardwareTyp.equals(Gateway.TYPE)) {
            tmp = "gfx/hardware/gateway.png";
        } else {
            tmp = null;
            LOG.debug("GUIContainer: ausgewaehlte Hardware-Komponente unbekannt!");
        }
        this.designDragPreview.setTyp(hardwareTyp);
        this.designDragPreview.setIcon(new ImageIcon(this.getClass().getResource("/" + tmp)));
        this.designDragPreview.setBounds(x, y, this.designDragPreview.getWidth(), this.designDragPreview.getHeight());
        this.designDragPreview.setVisible(true);
    }

    public boolean aufObjekt(Component komp, int x, int y) {
        return x > komp.getX() && x < komp.getX() + komp.getWidth() && y > komp.getY() && y < komp.getY() + komp.getHeight();
    }

    public void clearAllItems() {
        this.nodeItems.clear();
        this.cableItems.clear();
        this.docuItems.clear();
        this.desktopWindowList.clear();
        Lauscher.getLauscher().reset();
        this.updateViewport();
    }

    public void updateViewport() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIContainer), updateViewport()");
        this.networkPanel.updateViewport(this.nodeItems, this.cableItems);
        this.networkPanel.updateUI();
        if (this.activeSite == 2) {
            this.docuPanel.updateViewport(this.docuItems, false);
        } else {
            this.docuPanel.updateViewport(this.docuItems, this.activeSite == 3);
        }
        this.docuPanel.updateUI();
    }

    public void updateCables() {
        LOG.trace("INVOKED (" + this.hashCode() + ") " + this.getClass() + " (GUIContainer), updateCables()");
        ListIterator<GUIKabelItem> it = this.cableItems.listIterator();
        while (it.hasNext()) {
            GUIKabelItem tempCable = it.next();
            tempCable.getKabelpanel().updateBounds();
        }
    }

    public JSidebarButton getKabelvorschau() {
        return this.designCablePreview;
    }

    public int getActiveSite() {
        return this.activeSite;
    }

    public void setActiveSite(int activeSite) {
        this.activeSite = activeSite;
        for (Component background : this.layeredPane.getComponentsInLayer(BACKGROUND_LAYER)) {
            this.layeredPane.remove(background);
        }
        this.helpPanel.loadContext(activeSite);
        if (activeSite == 1) {
            this.closeDialogs();
            this.designView.getVerticalScrollBar().setValue(this.simulationView.getVerticalScrollBar().getValue());
            this.designView.getHorizontalScrollBar().setValue(this.simulationView.getHorizontalScrollBar().getValue());
            JMainFrame.getJMainFrame().removeFromContentPane(this.docuSidebarScrollpane);
            JMainFrame.getJMainFrame().addToContentPane(this.designSidebarScrollpane, "West");
            JMainFrame.getJMainFrame().removeFromContentPane(this.simulationView);
            this.layeredPane.setLayer(this.docuPanel, INACTIVE_LISTENER_LAYER);
            this.layeredPane.setLayer(this.designListenerPanel, ACTIVE_LISTENER_LAYER);
            this.layeredPane.add((Component)this.designBackgroundPanel, BACKGROUND_LAYER);
            this.designView.setViewportView(this.layeredPane);
            JMainFrame.getJMainFrame().addToContentPane(this.designView, "Center");
            JMainFrame.getJMainFrame().addToContentPane(this.designItemConfig, "South");
            this.setProperty(this.lastOpenDesignComponent);
            this.docuDragPanel.setVisible(false);
            this.designSidebarScrollpane.updateUI();
            this.designView.updateUI();
        } else if (activeSite == 3) {
            this.closeDialogs();
            this.designView.getVerticalScrollBar().setValue(this.simulationView.getVerticalScrollBar().getValue());
            this.designView.getHorizontalScrollBar().setValue(this.simulationView.getHorizontalScrollBar().getValue());
            JMainFrame.getJMainFrame().removeFromContentPane(this.designSidebarScrollpane);
            JMainFrame.getJMainFrame().addToContentPane(this.docuSidebarScrollpane, "West");
            JMainFrame.getJMainFrame().removeFromContentPane(this.simulationView);
            this.layeredPane.add((Component)this.designBackgroundPanel, BACKGROUND_LAYER);
            this.layeredPane.setLayer(this.docuPanel, ACTIVE_LISTENER_LAYER);
            this.layeredPane.setLayer(this.designListenerPanel, INACTIVE_LISTENER_LAYER);
            this.designView.setViewportView(this.layeredPane);
            this.designSelection.setVisible(false);
            this.designSelectionArea.setVisible(false);
            this.docuDragPanel.setVisible(true);
            JMainFrame.getJMainFrame().addToContentPane(this.designView, "Center");
            JMainFrame.getJMainFrame().removeFromContentPane(this.designItemConfig);
            this.docuSidebarScrollpane.updateUI();
            this.designView.updateUI();
        } else if (activeSite == 2) {
            this.reopenDialogs();
            this.simulationView.getVerticalScrollBar().setValue(this.designView.getVerticalScrollBar().getValue());
            this.simulationView.getHorizontalScrollBar().setValue(this.designView.getHorizontalScrollBar().getValue());
            this.layeredPane.setLayer(this.docuPanel, INACTIVE_LISTENER_LAYER);
            this.layeredPane.setLayer(this.designListenerPanel, INACTIVE_LISTENER_LAYER);
            this.layeredPane.add((Component)this.simulationBackgroundPanel, BACKGROUND_LAYER);
            this.simulationView.setViewportView(this.layeredPane);
            JMainFrame.getJMainFrame().removeFromContentPane(this.docuSidebarScrollpane);
            JMainFrame.getJMainFrame().removeFromContentPane(this.designSidebarScrollpane);
            this.designSelection.setVisible(false);
            this.designSelectionArea.setVisible(false);
            this.docuDragPanel.setVisible(false);
            JMainFrame.getJMainFrame().removeFromContentPane(this.designView);
            JMainFrame.getJMainFrame().addToContentPane(this.simulationView, "Center");
            JMainFrame.getJMainFrame().addToContentPane(this.designItemConfig, "South");
            this.setProperty(null);
            this.simulationView.updateUI();
        }
        GUIEvents.getGUIEvents().resetAndHideCablePreview();
        JMainFrame.getJMainFrame().invalidate();
        JMainFrame.getJMainFrame().validate();
        this.updateViewport();
    }

    public List<GUIKabelItem> getCableItems() {
        return this.cableItems;
    }

    public void setCablelist(List<GUIKabelItem> cablelist) {
        this.cableItems = cablelist;
    }

    public int getAbstandLinks() {
        int abstand = 0;
        abstand = GUIContainer.getGUIContainer().getSidebar().getLeistenpanel().getWidth();
        return abstand;
    }

    public int getAbstandOben() {
        int abstand = 0;
        abstand = GUIContainer.getGUIContainer().getMenu().getMenupanel().getHeight();
        return abstand;
    }

    @Deprecated
    public JMarkerPanel getMarkierung() {
        return this.designSelectionArea;
    }

    public void hideMarker() {
        this.designSelectionArea.setVisible(false);
    }

    public boolean isMarkerVisible() {
        return this.designSelectionArea.isVisible();
    }

    public void moveMarker(int incX, int incY, List<GUIKnotenItem> markedlist) {
        int newMarkerY;
        int newMarkerX = this.designSelectionArea.getX() + incX;
        if (newMarkerX + this.designSelectionArea.getWidth() >= this.width || newMarkerX < 0) {
            incX = 0;
        }
        if ((newMarkerY = this.designSelectionArea.getY() + incY) + this.designSelectionArea.getHeight() >= this.height || newMarkerY < 0) {
            incY = 0;
        }
        this.designSelectionArea.setBounds(this.designSelectionArea.getX() + incX, this.designSelectionArea.getY() + incY, this.designSelectionArea.getWidth(), this.designSelectionArea.getHeight());
        for (GUIKnotenItem knotenItem : markedlist) {
            JSidebarButton templbl = knotenItem.getImageLabel();
            templbl.setLocation(templbl.getX() + incX, templbl.getY() + incY);
        }
        this.updateCables();
    }

    public JMarkerPanel getAuswahl() {
        return this.designSelection;
    }

    public JSidebarButton getDragVorschau() {
        return this.designDragPreview;
    }

    public ControlPanel getProperty() {
        return this.designItemConfig;
    }

    public void showDesktop(GUIKnotenItem hardwareItem) {
        GUIDesktopWindow tmpDesktop = null;
        boolean fertig = false;
        if (hardwareItem != null && hardwareItem.getKnoten() instanceof Host) {
            Betriebssystem bs = (Betriebssystem)((Host)hardwareItem.getKnoten()).getSystemSoftware();
            ListIterator<GUIDesktopWindow> it = this.desktopWindowList.listIterator();
            while (!fertig && it.hasNext()) {
                tmpDesktop = it.next();
                if (bs != tmpDesktop.getBetriebssystem()) continue;
                tmpDesktop.setVisible(true);
                fertig = true;
            }
            if (!fertig) {
                tmpDesktop = new GUIDesktopWindow(bs);
                this.setDesktopPos(tmpDesktop);
                tmpDesktop.setVisible(true);
                tmpDesktop.toFront();
                fertig = true;
            }
            if (tmpDesktop != null) {
                this.desktopWindowList.add(tmpDesktop);
            }
        }
    }

    private void setDesktopPos(GUIDesktopWindow tmpDesktop) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension desktopSize = tmpDesktop.getSize();
        int numberOfDesktopsPerRow = (int)(screenSize.getWidth() / desktopSize.getWidth());
        int numberOfDesktopsPerColumn = (int)(screenSize.getHeight() / desktopSize.getHeight());
        int totalNumberOfDesktops = numberOfDesktopsPerRow * numberOfDesktopsPerColumn;
        int xPos = 10;
        int yPos = 10;
        if (this.desktopWindowList.size() < totalNumberOfDesktops && !Information.getDesktopWindowMode().equals((Object)GUIDesktopWindow.Mode.STACK)) {
            if (Information.getDesktopWindowMode().equals((Object)GUIDesktopWindow.Mode.COLUMN)) {
                xPos = 10 + this.desktopWindowList.size() / numberOfDesktopsPerColumn * (int)desktopSize.getWidth();
                yPos = 10 + this.desktopWindowList.size() % numberOfDesktopsPerColumn * (int)desktopSize.getHeight();
            } else {
                xPos = 10 + this.desktopWindowList.size() % numberOfDesktopsPerRow * (int)desktopSize.getWidth();
                yPos = 10 + this.desktopWindowList.size() / numberOfDesktopsPerRow * (int)desktopSize.getHeight();
            }
        } else {
            int overlappingDesktops = Information.getDesktopWindowMode().equals((Object)GUIDesktopWindow.Mode.STACK) ? this.desktopWindowList.size() : this.desktopWindowList.size() - totalNumberOfDesktops;
            xPos = (overlappingDesktops + 1) * 20;
            yPos = (overlappingDesktops + 1) * 20;
            if ((double)xPos + desktopSize.getWidth() > screenSize.getWidth()) {
                xPos = 10;
            }
            if ((double)yPos + desktopSize.getHeight() > screenSize.getHeight()) {
                yPos = 10;
            }
        }
        tmpDesktop.setBounds(xPos, yPos, tmpDesktop.getWidth(), tmpDesktop.getHeight());
    }

    public void closeDialogs() {
        this.visibleSystems.clear();
        for (GUIDesktopWindow window : this.desktopWindowList) {
            if (window.isVisible()) {
                this.visibleSystems.add(window.getBetriebssystem());
            }
            window.setVisible(false);
        }
        SatViewerControl.getInstance().hideViewer();
        this.lastVisibilityStateLauscher = ((JDialog)((Object)this.getExchangeDialog())).isVisible();
        ((JDialog)((Object)GUIContainer.getGUIContainer().getExchangeDialog())).setVisible(false);
    }

    public void reopenDialogs() {
        HashSet<SystemSoftware> systemSoftware = new HashSet<SystemSoftware>();
        for (GUIKnotenItem node : this.nodeItems) {
            systemSoftware.add(node.getKnoten().getSystemSoftware());
        }
        HashSet<GUIDesktopWindow> desktopsToRemove = new HashSet<GUIDesktopWindow>();
        for (GUIDesktopWindow window : this.desktopWindowList) {
            if (!systemSoftware.contains(window.getBetriebssystem())) {
                desktopsToRemove.add(window);
                continue;
            }
            if (!this.visibleSystems.contains(window.getBetriebssystem())) continue;
            window.setVisible(true);
        }
        for (GUIDesktopWindow window : desktopsToRemove) {
            this.desktopWindowList.remove(window);
        }
        SatViewerControl.getInstance().reshowViewer(systemSoftware);
        if (this.lastVisibilityStateLauscher) {
            ((JDialog)((Object)this.getExchangeDialog())).setVisible(true);
        }
        JMainFrame.getJMainFrame().setVisible(true);
    }

    public void setProperty(Hardware hardwareItem) {
        if (this.designItemConfig != null) {
            this.designItemConfig.doUnselectAction();
            JMainFrame.getJMainFrame().removeFromContentPane(this.designItemConfig);
        }
        if (this.activeSite == 1) {
            if (this.designItemConfig instanceof SimulationControl) {
                this.lastSimulationControlMaximized = this.designItemConfig.isMaximiert();
            }
            this.designItemConfig = JKonfiguration.getInstance(hardwareItem);
        } else {
            this.lastOpenDesignComponent = this.designItemConfig instanceof JKonfiguration && this.designItemConfig.isMaximiert() ? ((JKonfiguration)this.designItemConfig).holeHardware() : null;
            this.designItemConfig = new SimulationControl();
        }
        JMainFrame.getJMainFrame().addToContentPane(this.designItemConfig, "South");
        this.designItemConfig.updateAttribute();
        this.designItemConfig.updateUI();
        if (hardwareItem != null || this.designItemConfig instanceof SimulationControl && this.lastSimulationControlMaximized) {
            this.designItemConfig.maximieren();
        } else {
            this.designItemConfig.minimieren();
        }
    }

    public JScrollPane getScrollPane() {
        return this.designView;
    }

    public int getXOffset() {
        if (this.activeSite == 2) {
            return this.simulationView.getHorizontalScrollBar().getValue();
        }
        return this.designView.getHorizontalScrollBar().getValue();
    }

    public int getYOffset() {
        if (this.activeSite == 2) {
            return this.simulationView.getVerticalScrollBar().getValue();
        }
        return this.designView.getVerticalScrollBar().getValue();
    }

    public int getRealXPos(int x) {
        if (this.activeSite == 2) {
            return SwingUtilities.convertPoint((Component)this.simulationView, (Point)new Point((int)x, (int)0), (Component)this.simulationView.getViewport()).x;
        }
        return SwingUtilities.convertPoint((Component)this.designView, (Point)new Point((int)x, (int)0), (Component)this.designView.getViewport()).x;
    }

    public int getRealYPos(int y) {
        if (this.activeSite == 2) {
            return SwingUtilities.convertPoint((Component)this.simulationView, (Point)new Point((int)0, (int)y), (Component)this.simulationView.getViewport()).y;
        }
        return SwingUtilities.convertPoint((Component)this.designView, (Point)new Point((int)0, (int)y), (Component)this.designView.getViewport()).y;
    }

    public JScrollPane getSidebarScrollpane() {
        if (this.activeSite == 1) {
            return this.designSidebarScrollpane;
        }
        return this.docuSidebarScrollpane;
    }

    public GUINetworkPanel getDesignpanel() {
        return this.networkPanel;
    }

    public JComponent getSimpanel() {
        return this.simulationView;
    }

    public GUIDesignSidebar getSidebar() {
        return this.designSidebar;
    }

    public GUIMainMenu getMenu() {
        return this.menu;
    }

    public void setKabelPanelVorschau(JCablePanel kabelPanelVorschau) {
        this.kabelPanelVorschau = kabelPanelVorschau;
    }

    public JSidebarButton getLabelforKnoten(Knoten node) {
        List<GUIKnotenItem> list = this.getKnotenItems();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getKnoten().equals(node)) continue;
            return list.get(i).getImageLabel();
        }
        return null;
    }

    public List<GUIDocuItem> getDocuItems() {
        this.docuPanel.removeElementsFocus();
        return this.docuItems;
    }

    public void removeDocuElement(JDocuElement elem) {
        for (GUIDocuItem item : this.docuItems) {
            if (!item.asDocuElement().equals(elem)) continue;
            this.docuItems.remove(item);
            break;
        }
    }

    public void removeCableItem(GUIKabelItem cableItem) {
        this.cableItems.remove(cableItem);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void showHelp() {
        this.helpPanel.maximieren();
    }

    public void hideHelp() {
        this.helpPanel.minimieren();
    }

    private static enum FileType {
        PNG,
        SVG;

    }
}

