/*
 * Decompiled with CFR 0.152.
 */
package filius.gui;

import filius.gui.JBackgroundPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.MouseInputAdapter;

public class ControlPanel
extends JBackgroundPanel
implements Observer {
    private JBackgroundPanel contentPanel;
    protected JScrollPane scrollPane;
    protected Box box;
    protected Box middleBox;
    protected Box rightBox;
    private JLabel openClose;
    private static final int SIZE = 250;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int mode;
    private int sizeMaximized;

    protected ControlPanel() {
        this(1, 250);
    }

    protected ControlPanel(int mode, int size) {
        this.mode = mode;
        this.sizeMaximized = size;
        this.init();
        this.minimieren();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.contentPanel = new JBackgroundPanel();
        this.contentPanel.setBackgroundImage("gfx/allgemein/konfigPanel_hg.png");
        this.scrollPane = new JScrollPane(this.contentPanel);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        if (this.mode == 1) {
            this.scrollPane.setVerticalScrollBarPolicy(21);
        } else {
            this.scrollPane.setVerticalScrollBarPolicy(20);
        }
        this.add((Component)this.scrollPane, "Center");
        this.openClose = new JLabel(this.getIcon(false));
        this.openClose.setBounds(0, 0, this.openClose.getIcon().getIconWidth(), this.openClose.getIcon().getIconHeight());
        this.openClose.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ControlPanel.this.isMaximiert()) {
                    ControlPanel.this.minimieren();
                } else {
                    ControlPanel.this.maximieren();
                }
            }
        });
        this.add((Component)this.openClose, this.mode == 1 ? "North" : "West");
    }

    protected ImageIcon getIcon(boolean open) {
        ImageIcon icon = null;
        if (open && this.mode == 1) {
            icon = new ImageIcon(this.getClass().getResource("/gfx/allgemein/minimieren.png"));
        } else if (open && this.mode == 0) {
            icon = new ImageIcon(this.getClass().getResource("/gfx/allgemein/min_to_right.png"));
        } else if (!open && this.mode == 0) {
            icon = new ImageIcon(this.getClass().getResource("/gfx/allgemein/max_to_left.png"));
        } else if (!open && this.mode == 1) {
            icon = new ImageIcon(this.getClass().getResource("/gfx/allgemein/maximieren.png"));
        }
        return icon;
    }

    public void reInit() {
        this.contentPanel.removeAll();
        this.contentPanel.updateUI();
        this.contentPanel.setLayout(new BorderLayout());
        this.box = Box.createVerticalBox();
        this.box.setOpaque(false);
        this.box.setAlignmentX(0.0f);
        this.box.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Box auxBox = Box.createHorizontalBox();
        auxBox.add(Box.createVerticalGlue());
        auxBox.setOpaque(false);
        auxBox.setAlignmentX(0.0f);
        this.middleBox = Box.createVerticalBox();
        this.middleBox.setOpaque(false);
        this.middleBox.setAlignmentX(0.0f);
        this.middleBox.setAlignmentY(0.0f);
        this.middleBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        auxBox.add(this.middleBox);
        this.rightBox = Box.createVerticalBox();
        this.rightBox.setOpaque(false);
        this.rightBox.setAlignmentX(0.0f);
        this.rightBox.setAlignmentY(0.0f);
        this.rightBox.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        auxBox.add(this.rightBox);
        this.initContents();
        this.middleBox.add(Box.createVerticalGlue());
        this.rightBox.add(Box.createVerticalGlue());
        this.contentPanel.add((Component)this.box, "Center");
        this.contentPanel.add((Component)auxBox, "East");
        this.contentPanel.updateUI();
        this.contentPanel.invalidate();
        this.contentPanel.validate();
    }

    public void minimieren() {
        if (this.mode == 1) {
            this.setPreferredSize(new Dimension(this.getWidth(), this.openClose.getHeight()));
        } else {
            this.setPreferredSize(new Dimension(this.openClose.getWidth(), this.getHeight()));
        }
        this.openClose.setIcon(this.getIcon(false));
        this.contentPanel.setVisible(false);
        this.updateUI();
    }

    public void updateSettings() {
    }

    public void doUnselectAction() {
    }

    public void maximieren() {
        if (this.mode == 1) {
            this.setPreferredSize(new Dimension(this.getWidth(), this.sizeMaximized));
        } else {
            this.setPreferredSize(new Dimension(this.sizeMaximized, this.getHeight()));
            this.scrollPane.getViewport().setBounds(0, 0, this.sizeMaximized, Short.MAX_VALUE);
        }
        this.openClose.setIcon(this.getIcon(true));
        this.updateSettings();
        this.contentPanel.setVisible(true);
        this.updateUI();
    }

    public boolean isMaximiert() {
        return this.contentPanel.isVisible();
    }

    protected void initContents() {
    }

    public void updateAttribute() {
    }

    @Override
    public void update(Observable o, Object arg) {
        this.updateAttribute();
    }
}

