/*
 * Decompiled with CFR 0.152.
 */
package filius;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import filius.gui.GUIContainer;
import filius.gui.JMainFrame;
import filius.gui.SplashScreen;
import filius.hardware.Verbindung;
import filius.rahmenprogramm.FiliusArgs;
import filius.rahmenprogramm.I18n;
import filius.rahmenprogramm.Information;
import filius.rahmenprogramm.SzenarioVerwaltung;
import java.awt.Rectangle;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main
implements I18n {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String FRANCAIS = "Fran\u00e7ais";
    private static final String ENGLISH = "English";
    private static final String DEUTSCH = "Deutsch";

    public static void starten(String szenarioDatei) {
        LOG.trace("INVOKED (static) filius.Main, starten(" + szenarioDatei + ")");
        try {
            Information.getInformation().loadIni();
        }
        catch (IOException e1) {
            LOG.debug("ini could not be read: " + e1.getMessage());
        }
        String konfigPfad = Information.getInformation().getArbeitsbereichPfad() + "konfig.xml";
        if (!new File(konfigPfad).exists() && null == Information.getInformation().getLocale()) {
            Object[] possibleValues = new String[]{DEUTSCH, ENGLISH, FRANCAIS};
            String selectedValue = (String)JOptionPane.showInputDialog(null, "", "Sprache/Language/Langue", 1, null, possibleValues, possibleValues[0]);
            if (selectedValue == null) {
                Information.getInformation().setLocale(Locale.GERMANY);
            } else if (ENGLISH.equals(selectedValue)) {
                Information.getInformation().setLocale(Locale.UK);
            } else if (FRANCAIS.equals(selectedValue)) {
                Information.getInformation().setLocale(Locale.FRANCE);
            } else {
                Information.getInformation().setLocale(Locale.GERMANY);
            }
        } else {
            try {
                XMLDecoder xmldec = new XMLDecoder(new BufferedInputStream(Files.newInputStream(Paths.get(konfigPfad, new String[0]), new OpenOption[0])));
                Object[] programmKonfig = (Object[])xmldec.readObject();
                if (programmKonfig != null) {
                    if (programmKonfig.length >= 4) {
                        JMainFrame.getJMainFrame().setBounds((Rectangle)programmKonfig[0]);
                        if (szenarioDatei == null) {
                            szenarioDatei = (String)programmKonfig[1];
                        }
                        if (programmKonfig[2] != null && programmKonfig[3] != null && null == Information.getInformation().getLocale()) {
                            Information.getInformation().setLocale(new Locale((String)programmKonfig[2], (String)programmKonfig[3]));
                        }
                    }
                    if (programmKonfig.length >= 5) {
                        Information.getInformation().setLastOpenedDirectory((String)programmKonfig[4]);
                    }
                }
            }
            catch (Exception e) {
                LOG.debug("There is no user configuration available.");
            }
        }
        UIManager.put("OptionPane.cancelButtonText", messages.getString("main_dlg_CANCEL"));
        UIManager.put("OptionPane.noButtonText", messages.getString("main_dlg_NO"));
        UIManager.put("OptionPane.okButtonText", messages.getString("main_dlg_OK"));
        UIManager.put("OptionPane.yesButtonText", messages.getString("main_dlg_YES"));
        SplashScreen splashScreen = new SplashScreen("gfx/allgemein/splashscreen.png", null);
        splashScreen.setVisible(true);
        splashScreen.setAlwaysOnTop(true);
        long splashTime = System.currentTimeMillis();
        if (szenarioDatei != null) {
            try {
                SzenarioVerwaltung.getInstance().laden(szenarioDatei, GUIContainer.getGUIContainer().getKnotenItems(), GUIContainer.getGUIContainer().getCableItems(), GUIContainer.getGUIContainer().getDocuItems());
            }
            catch (Exception e) {
                LOG.debug("", e);
            }
        }
        GUIContainer.getGUIContainer().setProperty(null);
        GUIContainer.getGUIContainer().updateViewport();
        try {
            Thread.sleep(10L);
        }
        catch (Exception exception) {
            LOG.error("Caught an unexpected exception.", exception);
        }
        GUIContainer.getGUIContainer().updateCables();
        splashTime = System.currentTimeMillis() - splashTime;
        LOG.debug("Splash Screen shown for " + splashTime + " ms");
        if (splashTime < 1000L) {
            try {
                Thread.sleep(1000L - splashTime);
            }
            catch (Exception exception) {
                LOG.error("Caught an unexpected exception.", exception);
            }
        }
        splashScreen.setAlwaysOnTop(false);
        splashScreen.setVisible(false);
    }

    public static void beenden() {
        LOG.trace("INVOKED (static) filius.Main, beenden()");
        boolean abbruch = false;
        GUIContainer.getGUIContainer().getMenu().selectMode(1);
        if (SzenarioVerwaltung.getInstance().istGeaendert()) {
            int entscheidung = JOptionPane.showConfirmDialog(JMainFrame.getJMainFrame(), messages.getString("main_msg1"), messages.getString("main_msg2"), 0);
            boolean bl = abbruch = entscheidung != 0;
        }
        if (!abbruch) {
            Object[] programmKonfig = new Object[]{JMainFrame.getJMainFrame().getBounds(), SzenarioVerwaltung.getInstance().holePfad(), Information.getInformation().getLocale().getLanguage(), Information.getInformation().getLocale().getCountry(), Information.getInformation().getLastOpenedDirectory()};
            String applicationConfigPath = Information.getInformation().getArbeitsbereichPfad() + "konfig.xml";
            try (FileOutputStream fos = new FileOutputStream(applicationConfigPath);
                 XMLEncoder encoder = new XMLEncoder(new BufferedOutputStream(fos));){
                encoder.writeObject(programmKonfig);
            }
            catch (Exception e) {
                LOG.debug("", e);
            }
            SzenarioVerwaltung.loescheVerzeichnisInhalt(Information.getInformation().getTempPfad());
            System.exit(0);
        }
    }

    public static void main(String[] args) {
        FiliusArgs filiusArgs = new FiliusArgs();
        try {
            filiusArgs.parseCommandLine(args);
            if (filiusArgs.currWD.isEmpty() || !filiusArgs.currWD.substring(filiusArgs.currWD.length() - 1).equals(System.getProperty("file.separator"))) {
                if (Information.getInformation(filiusArgs.currWD + System.getProperty("file.separator")) == null) {
                    System.exit(6);
                } else if (Information.getInformation(filiusArgs.currWD) == null) {
                    System.exit(6);
                }
            }
            if (filiusArgs.log) {
                System.setProperty("FILIUS_LOG_LEVEL", "DEBUG");
                LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
                loggerContext.reset();
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext(loggerContext);
                try {
                    configurator.doConfigure(configurator.getClass().getResourceAsStream("/logback.xml"));
                    LOG.info("Log to file enabled.");
                }
                catch (JoranException exception) {
                    LOG.error("Caught an unexpected error while trying to load the logback configuration file..", exception);
                }
            }
            if (Information.getInformation(filiusArgs.currWD) == null) {
                System.exit(6);
            }
            Verbindung.setRTTfactor(filiusArgs.rtt);
            Information.setLowResolution(filiusArgs.lowResolution);
            if (filiusArgs.nativeLookAndFeel) {
                Main.activateNativeLookAndFeel();
            }
            if (filiusArgs.help) {
                filiusArgs.showUsageInformation();
            } else {
                Main.starten(filiusArgs.projectFile);
            }
        }
        catch (ParseException e) {
            filiusArgs.showUsageInformation();
        }
        LOG.debug("------------------------------------------------------");
        LOG.debug("\tJava Version: " + System.getProperty("java.version"));
        LOG.debug("\tJava Directory: " + System.getProperty("java.home"));
        LOG.debug("\tFILIUS Version: " + Information.getVersion());
        LOG.debug("\tParameters: '" + filiusArgs.argsString.trim() + "'");
        LOG.debug("\tFILIUS Installation: " + Information.getInformation().getProgrammPfad());
        LOG.debug("\tFILIUS Working Directory: " + Information.getInformation().getArbeitsbereichPfad());
        LOG.debug("\tFILIUS Temp Directory: " + Information.getInformation().getTempPfad());
        LOG.debug("------------------------------------------------------\n");
    }

    public static void activateNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException e) {
            LOG.warn("Native look and feel not supported. Using default look and feel.");
        }
        catch (ClassNotFoundException e) {
            LOG.warn("LookAndFeel class could not be found. Using default look and feel.");
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Could not instantiate LookAndFeel. Using default look and feel.");
        }
    }
}

